-- Owner für Demodaten
SET SESSION AUTHORIZATION 'DEMODATA';

DO $$
    DECLARE i INTEGER;
    BEGIN
     FOR i IN 1..9 LOOP
        INSERT INTO lagerorte
           (lgo_desc               , lgo_name           , lgo_nodelete)
        VALUES
           ('Lagerort ZZ0A0'||i::VARCHAR   , 'ZZ0A0'||i::VARCHAR, true),
           ('Lagerort ZZ0B0'||i::VARCHAR   , 'ZZ0B0'||i::VARCHAR, true);
     END LOOP;
 END $$;

  --1000 Dummy-Artikel
DO $$
     DECLARE i INTEGER;
     BEGIN
      --STAHL
      INSERT INTO adk
        (ad_krz,    ad_fa1,              ad_str,        ad_plz,  ad_ort,   ad_landiso, ad_land      , ad_ustidnr   )
      SELECT * FROM (
          SELECT 'STAHL', 'Stahl GmbH', 'Kruppweg 29', '11111', 'Berlin', 'DE'      , 'Deutschland', 'DE999999995'
      ) AS sub
      WHERE NOT exists( SELECT true FROM adk WHERE ad_krz = 'STAHL' );
      FOR i IN 1000..1050 LOOP
         INSERT INTO art
           (ak_ac   , ak_nr                         , ak_bez                                              , ak_mat               ,
            ak_dim              , ak_din          , ak_standard_mgc, ak_gewicht, ak_bfr, ak_hest              , AK_VKPBAS)
         VALUES
           ('RM1001', '1.2210 Ø14X1000-'||i::VARCHAR, 'Zählstahl Zählstange / Welle DIN 175 L'||i::VARCHAR, 'Z115CrV'||i::VARCHAR,
            'Ø Z14x'||i::VARCHAR, 'Z.'||i::VARCHAR,              4 ,        1.2,     20, 28.49+i/1000::NUMERIC, 38.49+i/1000::NUMERIC);

         --- Artikel-Lieferant anlegen
         INSERT INTO epreis --'1.2210 Ø14X1000', 'STAHL'
           (e_aknr                        , e_lkn  ,  e_stk, e_ep   , e_mcv                                                                                 , e_lfzt, e_stal)
         VALUES
           ('1.2210 Ø14X1000-'||i::VARCHAR, 'STAHL', 10    , i - 999, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc( '1.2210 Ø14X1000-' || i::VARCHAR ), 20   , true  );

      END LOOP;
 END $$;

DO $$
DECLARE _u VARCHAR;
         I Integer;
        --Artikel
            art_getriebe                VARCHAR :='G.PKW.A-1168534 /A';
            art_getriebe_verflach       VARCHAR :='G.PKW.A-1168534 /V';
            art_getriebe_mgcid          INTEGER :=tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_getriebe);
            art_getriebe_rep            VARCHAR :='G.PKW.A-RE-0001';
            art_getriebe_rep_welle      VARCHAR :='G.PKW.A-RE-0010';
            art_getriebe_rep_lager      VARCHAR :='G.PKW.A-RE-0011';
            art_getriebe_rep_option     VARCHAR :='G.PKW.A-RE-0001-OPT';
            art_welle                   VARCHAR :='W.13.N-272.371 /C';
            art_welle_mgcid             INTEGER :=tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_welle);
            art_lprofil                 VARCHAR :='L.100X1000-0001';
            art_zahnrad                 VARCHAR :='Z-21435000-L-Z64';
            art_zahnrad_mgcid           INTEGER :=tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_zahnrad);
            art_lochplatte              VARCHAR :='LP120X20X1';
        --Adressen
            adk_kunde_getr              VARCHAR :='GETRIEBE-GMBH';
            adk_kunde_auto              VARCHAR :='AUTO-AG';
            adk_kundeend_meyer          VARCHAR :='MEYER-DRE';
            adk_lief_elek               VARCHAR :='ELEKTR';

        --Projekt
            banf_pjnr                   VARCHAR := EXTRACT(year FROM current_date)::VARCHAR||'.013-W13';

        --Mengeneinheit Palette 10 Stk
            mgc_iso_palt_10     VARCHAR :='Palt. 10';
        --- Ab-/Zuschläge
            parent_id               INTEGER;
        --- Projektstruktur: Reperatur Getriebe Welle
            anst_id                 VARCHAR  := 'REP.GETR';

BEGIN
       IF current_user = 'postgres' THEN
         SET ROLE 'tester';
       END IF;
-- Stammdaten/Grunddaten/Predefines
 -- Mengeneinheiten
  INSERT INTO mgcode (me_cod, me_iso, me_bez)
  SELECT 60, mgc_iso_palt_10, 'Palette 10 Stk'
  WHERE NOT exists( SELECT true FROM mgcode WHERE me_iso = mgc_iso_palt_10 );

 --Achtung, folgende Beträge werden aktiv geprüft in uRT
  INSERT INTO abzu (abz_id, abz_txt, abz_type, abz_betrag)           VALUES (9001, 'uRT-Transport-Abzu-Betrag B 15'  ,'E', 15);
  INSERT INTO abzu (abz_id, abz_txt, abz_type, abz_betrag)           VALUES (9002, 'uRT-Rüstkosten-Artikelbezug-Abzu B 500'  ,'E', 500);
  INSERT INTO abzu (abz_id, abz_txt, abz_type, abz_betrag, abz_steu) VALUES (9003, 'uRT-Rüstkosten-Matzeugnis B 75 S 7'  ,'E', 75, 8);
  INSERT INTO abzu (abz_id, abz_txt, abz_type, abz_betrag, abz_steu) VALUES (9005, 'uRT-ÜbernachtungHotel-Abzu-Betrag 75 Steuersatz 7%','E', 20, 8);
  INSERT INTO abzu (abz_id, abz_txt, abz_type, abz_proz)             VALUES (9006, 'uRT-Versicherung-Abzu-Proz 10'  ,'E', 10);
 --
----------------------------------------------------------------------------------
--Kunden und Lieferantenstamm
 --Verkauf/Kunden anlegen, adk1, adk1abzu
    INSERT INTO adk1 (a1_krz, a1_knr) VALUES ('CIMPCS', 10999);
  --Getriebe GmbH
    INSERT INTO adk
      (ad_krz        , ad_fa1         , ad_str     , ad_plz , ad_ort  , ad_landiso, ad_land      , ad_ustidnr   )
     VALUES
      (adk_kunde_getr, 'Getriebe GmbH', 'Elbweg 92', '99099', 'Erfurt', 'DE'      , 'Deutschland', 'DE999999999');

    INSERT INTO adk1
      (a1_krz, a1_knr)
     VALUES
      (adk_kunde_getr, 10201);
  --Auto-AG
    INSERT INTO adk
      (ad_krz        , ad_fa1         , ad_str       , ad_plz , ad_ort   , ad_landiso, ad_land      , ad_ustidnr   , ad_such)
     VALUES
      (adk_kunde_auto, 'Automobile AG', 'Hauptweg 21', '99099', 'Dresden', 'DE'      , 'Deutschland', 'DE999999998', 'AUA');

    INSERT INTO adk1 (a1_krz, a1_knr)  VALUES  (adk_kunde_auto, 10202);

    INSERT INTO adk1abzu (a1z_krz, a1z_abz_id, a1z_betrag, a1z_type, a1z_pos) VALUES (adk_kunde_auto, 9001, 15, 'E', 9001); --'uRT-Transport-Abzu-Betrag 15'
    INSERT INTO adk1abzu (a1z_krz, a1z_abz_id, a1z_betrag, a1z_type, a1z_pos) VALUES (adk_kunde_auto, 9005, 75, 'E', 9005); --'uRT-ÜbernachtungHotel-Abzu-Betrag 75 Steuersatz 7%'
    INSERT INTO adk1abzu (a1z_krz, a1z_abz_id, a1z_proz,   a1z_type, a1z_pos) VALUES (adk_kunde_auto, 9006, 10, 'E', 9006); --'uRT-Versicherung-Abzu-Proz 10'

  -- Abweichende Liefer- und Rechnugnsadressen für Kunde Stahl; mit und ohne Ablaufdatum
    INSERT INTO adk_adresses
      (ada_ad_krz,     ada_ladress, ada_radress, ada_fa1,                      ada_adrzus,  ada_str,          ada_plz,            ada_ort,  ada_auslauf)
    VALUES
      (adk_kunde_getr, true,        false      , 'Getriebeanlieferungen GmbH', '',          'Holzweg 1',      '99099',            'Erfurt', '2019-12-31');
    INSERT INTO adk_adresses
      (ada_ad_krz,     ada_ladress, ada_radress, ada_fa1,                      ada_adrzus,  ada_str,          ada_plz,            ada_ort,  ada_auslauf)
    VALUES
      (adk_kunde_getr, true,        false      , 'Getriebe-Logistik GmbH'    , '',          'Gewerbering 29', '99099',            'Erfurt', NULL);
    INSERT INTO adk_adresses
      (ada_ad_krz,     ada_ladress, ada_radress, ada_fa1,                      ada_adrzus,  ada_str,          ada_plz,            ada_ort,  ada_auslauf)
    VALUES
      (adk_kunde_getr, false,       true       , 'Getrieberechnungslegungsstelle GmbH', '', 'Holzweg 19',     '99099',            'Erfurt', '2019-12-31');
    INSERT INTO adk_adresses
      (ada_ad_krz,     ada_ladress, ada_radress, ada_fa1,                      ada_adrzus,  ada_str,          ada_plz,            ada_ort,  ada_auslauf)
    VALUES
      (adk_kunde_getr, false,       false      , 'Getriebe-Buchhaltungs GmbH', 'Finanzdistrikt Süd', 'Gewerbering 81', '99099',   'Erfurt', NULL);

  -- ACHTUNG: weitere ADK1 nach Artikel

  --Meyer
    INSERT INTO adk
      (ad_krz            , ad_name, ad_vorn, ad_str               , ad_plz , ad_ort   , ad_landiso, ad_land      , ad_ustidnr   )
     VALUES
      (adk_kundeend_meyer, 'Meyer', 'Max'  , 'Theresienstraße 21', '01099', 'Dresden', 'DE'       , 'Deutschland', 'DE999999997');

    INSERT INTO adk1
      (a1_krz, a1_knr)
     VALUES
      (adk_kundeend_meyer, 10203);

 --
 --Lieferanten anlegen (Auswärtsbearbeiter)
  --ZERSP
    INSERT INTO adk
      (ad_krz , ad_fa1         , ad_str              , ad_plz , ad_ort      , ad_landiso, ad_land      , ad_ustidnr   )
     VALUES
      ('ZERSP', 'ZERSPAHN GmbH', 'Industriestaße 922', '22222', 'Stapelfeld',   'DE'    , 'Deutschland', 'DE999999996');

    INSERT INTO adk1 (a1_krz, a1_knr) VALUES ('ZERSP', 11000);

    INSERT INTO adk2
      (a2_krz, a2_knr)
     VALUES
      ('ZERSP', 70101);

    INSERT INTO adk1 (a1_krz, a1_knr) VALUES ('STAHL', 11001);

    INSERT INTO adk2
      (a2_krz, a2_knr)
     VALUES
      ('STAHL', 70102);
  --ELEKTR
    INSERT INTO adk
      (ad_krz,    ad_fa1,              ad_str,        ad_plz,  ad_ort,   ad_landiso, ad_land      , ad_ustidnr   )
     VALUES
      (adk_lief_elek, 'Elektronik GmbH', 'Gewerbegebiet 9', '11111', 'München', 'DE'      , 'Deutschland', 'DE999999994');
    --
    INSERT INTO adk2 (a2_krz, a2_knr) VALUES (adk_lief_elek, 71003);
  --Glüherei
    INSERT INTO adk
      (ad_krz,    ad_fa1,              ad_str,        ad_plz,  ad_ort,   ad_landiso, ad_land      , ad_ustidnr   )
     VALUES
      ('GLU', 'Glühen und Veredeln GmbH', 'Gewerbegebiet 17', '95367', 'Hannover', 'DE'      , 'Deutschland', 'DE999999993');
    --
    INSERT INTO adk2 (a2_krz, a2_knr) VALUES ('GLU', 70104);
  --HALBS
    INSERT INTO adk
      (ad_krz,    ad_fa1,              ad_str,        ad_plz,  ad_ort,   ad_landiso, ad_land      , ad_ustidnr   )
     VALUES
      ('HALBS', 'Halbfertig Stahl GmbH', 'Berliner Str. 1', '38820', 'Halberstadt' , 'DE'      , 'Deutschland', 'DE999999992');

    INSERT INTO adk2 (a2_krz, a2_knr) VALUES ('HALBS', 70105);
  --
 --
----------------------------------------------------------------------------------
--Kostenstellen anlegen
  --DRE Drehen
    INSERT INTO ksv
      (ks_abt, ks_bks  , ks_sts, ks_gss, ks_stsr, ks_gssr)
     VALUES
      ('DRE-001' , 'Drehen auf 150N - Halle 1', 75    , 70    , 85     , 80);
    INSERT INTO ksv
      (ks_abt, ks_bks, ks_bz , ks_sts, ks_gss, ks_stsr, ks_gssr)
     VALUES
      ('FRA-001', 'Fräsmaschine EMCO CM55', 'Trainingsfabrik', 105, 95, 120, 110); --FRA2
  --SAG Sägen
    INSERT INTO ksv
      (ks_abt, ks_bks, ks_bz , ks_sts, ks_gss, ks_stsr, ks_gssr)
    VALUES
     ('SAG-002', 'Aluminium-Kreissäge BERG&SCHMID "Velox 350"', 'Trainingsfabrik', 45    , 40    , 50     , 45); --SAE2
    INSERT INTO ksv
      (ks_abt, ks_bks , ks_sts, ks_gss, ks_stsr, ks_gssr)
     VALUES
      ('SAG-005' , 'Sägen', 45    , 40    , 50     , 45);
  --MON Gesamtpersonal
    INSERT INTO ksv
      (ks_abt     , ks_bks                  , ks_sts, ks_gss, ks_stsr, ks_gssr, ks_babz     , ks_babz1)
     VALUES
      ('MON-PERS' , 'Montage Gesamtpersonal', 55    , 50    , 60     , 55     , 'Schuchardt', 'Meyer');
  --MON Montage
    INSERT INTO ksv
      (ks_abt    , ks_bks             , ks_sts, ks_gss, ks_stsr, ks_gssr, ks_babz     , ks_ba1, ks_babz1, ks_planpool, ks_top_ksabt)
     VALUES
      ('MON-001' , 'Montieren Halle 1', 55    , 50    , 60     , 55     , 'Schuchardt', 1     , 'Meyer' , True       , 'MON-PERS');
  --MON Elektro
    INSERT INTO ksv
      (ks_abt    , ks_bks              , ks_sts, ks_gss, ks_stsr, ks_gssr, ks_babz   , ks_top_ksabt)
     VALUES
      ('MON-ELEK', 'Montage Elektronik', 55    , 50    , 60     , 55     , 'MON-PERS', 'MON-PERS');
  --Glühen / Härten
    INSERT INTO ksv
      (ks_abt, ks_bks     , ks_ausw, ks_krzl, ks_dlz)
     VALUES
      ('GLU-001' , 'Glühen', true, 'GLU', 5);
  --Standardkostenstelle QS
    INSERT INTO ksv(ks_abt, ks_bks  , ks_sts, ks_gss, ks_stsr, ks_gssr)
     VALUES ('QS-001' , 'Qualitätssicherung', 75    , 70    , 85     , 80);

  --SBM Ständerbohrmaschine
    INSERT INTO ksv
      (ks_abt    , ks_bks                    , ks_sts, ks_gss, ks_stsr, ks_gssr, ks_babz     , ks_ba1, ks_babz1)
     VALUES
      ('SBM-001' , 'Ständerbohrmaschine BK33', 55    , 50    , 60     , 55     , 'Schuchardt', 1     , 'Meyer');

-- Nicht mehr notwendig. Wird jetzt automatisch bei der Erstellung der ksvba-Einträge durch die Trigger ksvba_005_sync_resource_a__iu und resource_005_sync_resource_timeline_a__iu erledigt.
--   -- Ausschaltzeiten in Resource_Timeline eintragen.
--   PERFORM scheduling.resource_timeline__renew_offtime(
--                                   -- alle ksvba-Ressourcen
--               _resource_id      => scheduling.resource__translate__ksvba__shorthand__to__resource_id(ksb_ks_shorthand)
--                                   -- Früheste Planwoche der offenen AGe oder, falls früher heute - 3 Monate
--             , _timeframe_start  => current_date - 30
--                                   -- Späteste Planwoche der offenen AGe + 1 Woche oder, falls später heute + 2 Jahre
--             , _timeframe_end    => current_date + 90
--          )
--     FROM ksvba;



--Plantafel
  INSERT INTO plant_register (ptr_name) VALUES ('1: Fertigung');
  INSERT INTO plant_ks (pt_ks, pt_ptr_name, pt_top, pt_left, pt_width, pt_height) VALUES ('DRE-001', '1: Fertigung', 1, 0, 560, 740);
  INSERT INTO plant_ks (pt_ks, pt_ptr_name, pt_top, pt_left, pt_width, pt_height) VALUES ('FRA-001', '1: Fertigung', 1, 562, 325, 740);

----------------------------------------------------------------------------------
--Artikel anlegen
 -- Dienstleistungen/Auswärtsarbeitspakete, Reperatur und Optionsartikel
  -- Glühen 500°
   INSERT INTO art (ak_ac, ak_nr, ak_bez, ak_standard_mgc, ak_lag) VALUES
     ('DLEXT', 'GLU-500', 'Glühen 500°', 1, FALSE);
  -- Reperatur Getriebe: Generalüberholung; Optionsartikel
   INSERT INTO art (ak_ac, ak_nr, ak_bez, ak_standard_mgc, ak_lag, ak_such, ak_kunde, ak_hest, ak_vkpbas, ak_auftxt) VALUES
     ('DLINT', art_getriebe_rep, 'Getriebe PKW 1168534 : Überholung', 1, FALSE, 'Reperatur', '#', 450, 800, 'Komplettüberholung Getriebe nach 2000 Betriebsstunden'||E'\n'||'Überholung enthält:');
   INSERT INTO art (ak_ac, ak_nr, ak_bez, ak_standard_mgc, ak_lag, ak_kunde, ak_such, ak_auftxt) VALUES
     ('DLINT', art_getriebe_rep_welle, 'Getriebe PKW 1168534 : Austausch Wellen', 1, FALSE, '#', 'Reperatur', 'Überarbeitung und Austausch der Wellen.'||E'\n'||' Kurbelwelle'||E'\n'||' Nockenwelle');
   INSERT INTO art (ak_ac, ak_nr, ak_bez, ak_standard_mgc, ak_lag, ak_kunde, ak_such, ak_auftxt) VALUES
     ('DLINT', art_getriebe_rep_lager, 'Getriebe PKW 1168534 : Austausch Lagerschalen', 1, FALSE, '#', 'Reperatur', 'Prüfung der Lagerschalen'||E'\n'||' Lagerschalen Kurbelwelle wechseln'||E'\n'||' Lagerschalen Nockenwelle prüfen und ggf wechseln');
   INSERT INTO art (ak_ac, ak_nr, ak_bez, ak_standard_mgc, ak_lag, ak_kunde, ak_such) VALUES
     ('S', art_getriebe_rep_option, 'Getriebeüberarbeitung: Optional:', 1, FALSE, '#', 'Reperatur Optional: Austausch folgender Komponenten');
   --INSERT INTO artoption_arts
   --  (aoa_pos, aoa_g_ak_nr, aoa_ak_nr) VALUES (1, art_getriebe_rep_option, art_zahnrad);
   INSERT INTO artoption_arts
     (aoa_pos, aoa_g_ak_nr, aoa_ak_nr) VALUES (2, art_getriebe_rep_option, art_getriebe_rep_lager);

 -- Fertigungsartikel, Kaufteile, Rohmaterial, Lieferantendaten anlegen
  --Rohmaterial Rundstange Lieferant STAHL, ZERSP
    INSERT INTO art --'1.2210 Ø14X1000', 'Silberstahl Rundstange
      (ak_ac,     ak_nr,            ak_bez,                                   ak_mat,    ak_dim,      ak_din,   ak_standard_mgc, ak_gewicht, ak_bfr, ak_hest, AK_VKPBAS)
     VALUES
      ('RM1001', '1.2210 Ø14X1000', 'Silberstahl Rundstange / Welle DIN 175', '115CrV3', 'Ø 14x1000', '1.2210',          4 ,        1.2,     20,     20/*uRT*/  , 25/*uRT*/); --Faktor 1.25 in Vorgaben, beachte Lieferantendpreise übereinstimmend

    INSERT INTO epreis --'1.2210 Ø14X1000', 'STAHL'
      (e_aknr           , e_lkn,  e_stk    , e_ep , e_mcv                             , e_lfzt, e_stal)
     VALUES
      ('1.2210 Ø14X1000', 'STAHL', 9,     10, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('1.2210 Ø14X1000'),       20    , true  )
     RETURNING e_id INTO i;

    INSERT INTO twawi.epreis_abzu (az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('E', 9001, 9001, i, 1, 15); --'uRT-Transport-Abzu-Betrag 15'
    INSERT INTO twawi.epreis_abzu (az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('E', 9003, 9003, i, 1, 75); --'uRT-Rüstkosten-Matzeugnis B 75 S 7'
                                                                                                                                       --Hinweis: Summe 90, dadurch Grundpreis Artikelstamm gerade
    INSERT INTO epreis --'1.2210 Ø14X1000', 'ZERSP'
      (e_aknr           , e_lkn ,  e_stk,   e_ep , e_mcv                             , e_lfzt, e_stal)
     VALUES
      ('1.2210 Ø14X1000', 'ZERSP', 6,       13, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('1.2210 Ø14X1000'), 20    , False  ) RETURNING e_id INTO i;

    --INSERT INTO twawi.epreis_abzu (az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('E', 9001, 9001, i, 1, 15); --'uRT-Transport-Abzu-Betrag 15'
    INSERT INTO twawi.epreis_abzu (az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('E', 9003, 9003, i, 1, 75); --'uRT-Rüstkosten-Matzeugnis B 75 S 7'


  --Kaufteil Zahnrad Lieferant ZERSP
    INSERT INTO art --art_zahnrad
      (ak_ac   , ak_nr             , ak_znr    , ak_bez   , ak_mat                    , ak_dim                                  ,
       ak_standard_mgc, ak_gewicht, ak_bfr, ak_hest, AK_VKPBAS)
     VALUES
      ('KT1001', art_zahnrad, '21435000', 'Zahnrad', 'Automatenstahl 11SMnPB30', 'Ø53 mm, 64 Zähne, 20 ° schräg verzahnt',
       1              ,       0.2 ,    10 ,  25.67 , 54.32    );
     art_zahnrad_mgcid := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_zahnrad);

    INSERT INTO epreis --art_zahnrad, 'ZERSP'
      (e_aknr,       e_lkn , e_best,     e_ep,  e_mcv,             e_lfzt, e_stal)
     VALUES
      (art_zahnrad, 'ZERSP', 'L-Z64 #1', 25.67, art_zahnrad_mgcid, 10    , true  ) RETURNING e_id INTO i;
    INSERT INTO twawi.epreis_abzu (az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('E', 9001, 9001, i, 1, 15); --'uRT-Transport-Abzu-Betrag 15'
    INSERT INTO twawi.epreis_abzu (az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('E', 9003, 9003, i, 1, 75); --'uRT-Rüstkosten-Matzeugnis B 75 S 7'

    -- Gleicher Lieferant ein 2. mal mit anderer Referenz-Nummer zum Testen das richtiger E-Preis-Datensatz übernommen wird bei manueler Auswahl
    INSERT INTO epreis --art_zahnrad, 'ZERSP'
      (e_aknr,       e_lkn , e_best,     e_ep,  e_mcv,             e_lfzt, e_stal)
     VALUES
      (art_zahnrad, 'ZERSP', 'L-Z64 #2', 22.11, art_zahnrad_mgcid, 3     , false  );

                                                                                                                                             --Hinweis: Summe 90, dadurch Grundpreis Artikelstamm gerade
    INSERT INTO epreis --- art_zahnrad, 'STAHL' #7439
      (e_aknr     , e_lkn  , e_ep , e_mcv            , e_lfzt, e_stal)
     VALUES
      (art_zahnrad, 'STAHL', 29.99, art_zahnrad_mgcid, 10    , false ) RETURNING e_id INTO i;
    INSERT INTO twawi.epreis_abzu (az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('E', 9001, 9001, i, 1, 15); --'uRT-Transport-Abzu-Betrag 15'
    INSERT INTO twawi.epreis_abzu (az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('E', 9003, 9003, i, 1, 75); --'uRT-Rüstkosten-Matzeugnis B 75 S 7'
                                                                                                                                       --Hinweis: Summe 90, dadurch Grundpreis Artikelstamm gerade
    -- Selbstkosten setzen 'Z-21435000-L-Z64'
    UPDATE art SET ak_hest = 70.67 WHERE ak_nr = art_zahnrad;
    ---
    --- Staffelpreise 'Z-21435000-L-Z64'
    INSERT INTO artstp (astp_aknr, astp_menge, astp_vkp) VALUES (art_zahnrad, 10, 20);
    INSERT INTO artstp (astp_aknr, astp_menge, astp_vkp) VALUES (art_zahnrad, 20, 15);
    ---
    INSERT INTO artoption_arts
     (aoa_pos, aoa_g_ak_nr, aoa_ak_nr) VALUES (1, art_getriebe_rep_option, art_zahnrad);

 --Produktionsteil Welle Nut, Getriebe PKW
    INSERT INTO art --art_welle Welle Nut
      (ak_ac   , ak_nr              , ak_znr   ,  ak_idx, ak_bez    , ak_mat   , ak_dim     , ak_din  , ak_standard_mgc, ak_kunde, ak_bfr,      ak_hest, AK_VKPBAS, ak_auftxt)
     VALUES
      ('PR1001', art_welle, '272.371', 'Rev. 95/0002', 'Welle Nut', '115CrV3', 'Ø13x37 mm', '1.2210',              1 ,     '#', 25,       12.55 , 18.75 /*uRT*/, 'ak_auftxt_de');
    art_welle_mgcid := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_welle);

    INSERT INTO artstp (astp_aknr, astp_menge, astp_vkp) VALUES (art_welle, 90, 16.5); --uRT
    INSERT INTO artmgc (m_ak_nr, m_mgcode, m_uf) VALUES (art_welle, 60, 0.1);  --Palette 10 Stück

    INSERT INTO art --art_getriebe Getriebe PKW
      (ak_ac   , ak_nr               , ak_znr   , ak_bez        ,       ak_dim,   ak_standard_mgc, ak_bfr, ak_kunde, ak_vkpbas)
     VALUES
      ('PR1001', art_getriebe, '1168534', 'Getriebe PKW', '550x600 mm',          1 ,     60, adk_kunde_auto, 1559.39490);

    INSERT INTO art --art_getriebe Getriebe PKW
      (ak_ac   , ak_nr               , ak_znr   , ak_bez        ,       ak_dim,   ak_standard_mgc, ak_bfr, ak_kunde)
     VALUES
      ('PR1001', art_getriebe_verflach, '1168534', 'Getriebe PKW Verflachte Stückliste', '550x600 mm',          1 ,     60, adk_kunde_auto);


 -- Produktionsteil: L-Profil (mit Zuschnitt in AVOR)
    INSERT INTO art
      (ak_ac   , ak_nr        , ak_znr           ,  ak_bez              , ak_mat   , ak_dim          , ak_din  , ak_standard_mgc, ak_bfr,      ak_hest, AK_VKPBAS)
     VALUES
      ('PR1001', art_lprofil, art_lprofil, 'L-Profil Silberstahl', '115CrV3', '100mm x 1000mm', '1.2210',  1 ,              25,       12.55 , 18.75);
 -- Teile für Bordcomputer Lieferant ELEK für Sensoreinheit SERIENNUMMERNPFLICHT (Konstruktions/Fertigugnsstückliste)
    INSERT INTO art --Bordcomputer
      (ak_ac   , ak_nr               , ak_znr   , ak_bez, ak_bfr)
     VALUES
      ('PR1001', 'E.B.PKW.A-1168534 /A', 'E.B.1168534', 'Bordcomputer PKW', 30);

    INSERT INTO art --Platine
      (ak_ac   , ak_nr               , ak_znr   , ak_bez, ak_min, ak_bfr, ak_vkpfaktor, ak_hest, ak_vkpbas)
     VALUES
      ('KT1001', 'E.B.PKW.A-1168534-0001 /A', 'E.B.1168534-0001', 'Platine Ansteuerung eine Sensoreinheit', 20, 30, 2, 149, 298);
    INSERT INTO epreis --Lieferant ELEK für
      (e_aknr                     , e_best           , e_lkn   , e_ep , e_mcv                              , e_lfzt, e_stal)
     VALUES
      ('E.B.PKW.A-1168534-0001 /A', '1168534'        , 'ELEKTR', 149, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('E.B.PKW.A-1168534-0001 /A'), 30    , true  );

    INSERT INTO art --Getriebe Sensoreinheit SERIENNUMMERNPFLICHT
      (ak_ac   , ak_nr               , ak_znr   , ak_bez, ak_sernrreq, ak_bfr, ak_vkpfaktor, ak_hest, ak_vkpbas, ak_slort, ak_such)
     VALUES
      ('KT1001', 'E.B.PKW.A-1168534-0100 /A', 'E.B.1168534-0100', 'Getriebe Sensoreinheit', true, 30, 2, 18.75, 37.5, 'WE', 'SERNR');
    INSERT INTO epreis --Lieferant ELEK für
      (e_aknr                     , e_best           , e_lkn   , e_ep , e_mcv                              , e_lfzt, e_stal)
     VALUES
      ('E.B.PKW.A-1168534-0100 /A', '1168534'        , 'ELEKTR', 18.75, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('E.B.PKW.A-1168534-0100 /A'), 30    , true  );
    --2 "Fakeartikel" derzeit ohne Verwendung
    INSERT INTO art --Kühlung Sensoreinheit
      (ak_ac   , ak_nr               , ak_znr   , ak_bez, ak_bfr)
     VALUES
      ('KT1001', 'E.B.PKW.A-1168534-0101 /A', 'E.B.1168534-0101', 'Kühlung Sensoreinheit', 30);

    INSERT INTO art  --ABS Steuereinheit
      (ak_ac   , ak_nr               , ak_znr   , ak_bez, ak_bfr)
     VALUES
      ('KT1001', 'E.B.PKW.A-1168534-0102 /A', 'E.B.1168534-0102', 'Bremsanlage Sensoreinheit, ABS-Steuerelektronik', 30);

 -- Kaufteil: "Lochplatte 120x20x1" für FolgeABK
    INSERT INTO art
      (ak_ac   , ak_nr         , ak_znr        ,  ak_bez              , ak_mat   , ak_dim              , ak_such , ak_din  , ak_standard_mgc)
     VALUES
      ('KT1001', art_lochplatte, art_lochplatte, 'Lochplatte 120x20x1', '115CrV3', '120mm x 20mm x 1mm', 'PLATTE', '1.2210',  1);


  --Set-Artikel
    INSERT INTO art
      (ak_ac   , ak_nr              ,ak_bez,                 ak_standard_mgc)
     VALUES
      ('S',      'S.W.13.1100001', 'Dichtsatz Welle 13 mm',               1);

    INSERT INTO art
      (ak_ac   , ak_nr              ,ak_bez,                 ak_standard_mgc)
     VALUES
      ('KT1001', 'D.W.13.1100002', 'Dichtung 13 mm',         1);

    INSERT INTO art
      (ak_ac   , ak_nr              ,ak_bez,                 ak_standard_mgc)
     VALUES
      ('KT1001', 'D.W.13.1100003', 'Dichtung-Einsatz 13 mm',         1);

    INSERT INTO art
      (ak_ac   , ak_nr              ,ak_bez,                 ak_standard_mgc)
     VALUES
      ('KT1001', 'D.W.13.1100004', 'Dichtung-Schutz13 mm',         1);



--Adk1Abzu-Artikel
  INSERT INTO adk1abzu (a1z_krz, a1z_aknr, a1z_abz_id, a1z_betrag, a1z_type, a1z_pos) VALUES (adk_kunde_auto, art_welle, 9002, 500, 'E', 9002);
-------------------------------------------------------------------------------------
--Stückliste anlegen
 --Getriebe
  --Welle
    INSERT INTO stv
      (st_zn, st_n, st_pos, st_m, st_mgc)          VALUES  (art_getriebe,  art_welle,    10 ,   2   , art_welle_mgcid);
  --Welle
    INSERT INTO stv
      (st_zn, st_n, st_pos, st_m, st_mgc, st_txt)  VALUES  (art_getriebe,  art_welle,    15 ,   3   , art_welle_mgcid, 'ABK zusammenfassen')
    RETURNING st_id INTO i;

  --Variante
    INSERT INTO stv_vari (stvv_st_id, stvv_v)
     VALUES (i, 'Allrad');

  --Zahnrad
    INSERT INTO stv
      (st_zn, st_n, st_pos, st_m, st_mgc)          VALUES  (art_getriebe,  art_zahnrad,  20 ,   6   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_zahnrad));

 --Set-Artikel Dichtsatz; Setzen stvzutxt - status
    INSERT INTO stvzutxt (stv_zn, stv_stat) VALUES ('S.W.13.1100001', 'PS');

    INSERT INTO stv
      (st_zn,           st_n            , st_pos,    st_m, st_mgc)
     VALUES
      ('S.W.13.1100001',  'D.W.13.1100002' ,    10 ,   1   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('D.W.13.1100002'));

    INSERT INTO stv
      (st_zn,           st_n            , st_pos,    st_m, st_mgc)
     VALUES
      ('S.W.13.1100001',  'D.W.13.1100003' ,    20 ,   2   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('D.W.13.1100003'));

    INSERT INTO stv
      (st_zn,           st_n            , st_pos,    st_m, st_mgc)
     VALUES
      ('S.W.13.1100001',  'D.W.13.1100004' ,    30 ,   2   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('D.W.13.1100004'));

    INSERT INTO stv
      (st_zn,           st_n            , st_pos,    st_m, st_mgc)
     VALUES
      ('S.W.13.1100001',  'D.W.13.1100002' ,    40 ,   1   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('D.W.13.1100002'))
     RETURNING st_id INTO i;

    --Variante
    INSERT INTO stv_vari (stvv_st_id, stvv_v)
     VALUES (i, 'Allrad');

 --Set-Artikel unter Getriebe
    INSERT INTO stv
      (st_zn,           st_n            , st_pos,    st_m, st_mgc)
     VALUES
      (art_getriebe,  'S.W.13.1100001' ,    30 ,   1   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('S.W.13.1100001'));


 --Bordcomputer
  --Platine ACHTUNG pro Steuereinheit eine Platine. Bei Erweiterung Zahlen beachten!
    INSERT INTO stv
      (st_zn,           st_n            , st_pos,    st_m, st_mgc)
     VALUES
      ('E.B.PKW.A-1168534 /A',  'E.B.PKW.A-1168534-0001 /A',    10 ,   3   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('E.B.PKW.A-1168534-0001 /A'));

  --Getriebe Sensoreinheit
    INSERT INTO stv
      (st_zn,           st_n            , st_pos,    st_m, st_mgc)
     VALUES
      ('E.B.PKW.A-1168534 /A',  'E.B.PKW.A-1168534-0100 /A' ,    20 ,   1   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('E.B.PKW.A-1168534-0100 /A'));

  --Kühlung Sensoreinheit
    INSERT INTO stv
      (st_zn,           st_n            , st_pos,    st_m, st_mgc)
     VALUES
      ('E.B.PKW.A-1168534 /A',  'E.B.PKW.A-1168534-0101 /A' ,    30 ,   1   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('E.B.PKW.A-1168534-0101 /A'));

  --Bremsanlage Sensoreinheit
    INSERT INTO stv
      (st_zn,           st_n            , st_pos,    st_m, st_mgc)
     VALUES
      ('E.B.PKW.A-1168534 /A',  'E.B.PKW.A-1168534-0102 /A' ,    40 ,   1   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('E.B.PKW.A-1168534-0102 /A'));



 --
 --Getriebe verflacht
  --Welle
    INSERT INTO stv
      (st_zn, st_n, st_pos, st_m, st_mgc)          VALUES  (art_getriebe_verflach,  art_welle,    10 ,   2   , art_welle_mgcid);
  --Welle
    INSERT INTO stv
      (st_zn, st_n, st_pos, st_m, st_mgc, st_txt)  VALUES  (art_getriebe_verflach,  art_welle,    15 ,   3   , art_welle_mgcid, 'ABK zusammenfassen');
  --Zahnrad
    INSERT INTO stv
      (st_zn, st_n, st_pos, st_m, st_mgc)          VALUES  (art_getriebe_verflach,  art_zahnrad,  20 ,   6   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_zahnrad));

  --Bordcomputer als STR Element
    INSERT INTO stv
      (st_zn,           st_n            , st_pos,    st_m, st_mgc, st_stat)
     VALUES
      (art_getriebe_verflach,  'E.B.PKW.A-1168534 /A',    30 ,   1   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('E.B.PKW.A-1168534 /A'), 'STR');
  --Platine ACHTUNG pro Steuereinheit eine Platine. Bei Erweiterung Zahlen beachten!
    INSERT INTO stv
      (st_zn,           st_n            , st_pos,   st_pos_parent, st_m, st_mgc, st_posinfo)
     VALUES
      (art_getriebe_verflach,  'E.B.PKW.A-1168534-0001 /A',    40, 30,   1   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('E.B.PKW.A-1168534-0001 /A'), 'A.010');
  --Kühlung
    INSERT INTO stv
      (st_zn,           st_n            , st_pos,   st_pos_parent, st_m, st_mgc, st_stat, st_posinfo )
     VALUES
      (art_getriebe_verflach,  'E.B.PKW.A-1168534-0101 /A',    50 , 30,  2   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('E.B.PKW.A-1168534-0101 /A'), 'STR', 'A.030');
  --Kolben unter Kühlung
    INSERT INTO stv
      (st_zn,           st_n            , st_pos,   st_pos_parent, st_m, st_mgc, st_posinfo )
     VALUES
      (art_getriebe_verflach,  art_lprofil,    60 , 50,  4   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_lprofil), 'B.010');
 --
 --Arbeitspaket anlegen: Bordcomputer Sensoren in Getriebe montieren, Setzen stvzutxt - status
    INSERT INTO art
      (ak_ac  , ak_nr                   , ak_znr   , ak_bez                 , ak_mat   , ak_dim, ak_din, ak_standard_mgc, ak_bfr, ak_hest, AK_VKPBAS)
     VALUES
      ('DLINT', 'G.PKW.MON-BC.A-1168534 /A', ''       , 'Montage Geriebe Bordcomputer PKW.A', ''       , ''    , ''    , 1              , 25    , 0.0    , 0.0);

 --Erstellen Montage-Stückliste aus Konstruktionsstückliste Bordcomputer unter Arbeitspaket und Verknüpfen der darin enthaltenen Teile mit deren Konstruktionsstückliste
 --Montage Getriebe hat Teile aus Konstruktionsstückliste Bordcomputer
    INSERT INTO stvzutxt (stv_zn, stv_isfertigungsstv) VALUES ('G.PKW.MON-BC.A-1168534 /A', true);

    INSERT INTO stv
      (st_zn, st_n, st_pos, st_mgc, st_m, st_m_fix, st_kstv_st_id)
     VALUES
      --Platine
      ('G.PKW.MON-BC.A-1168534 /A', 'E.B.PKW.A-1168534-0001 /A', 10    , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('E.B.PKW.A-1168534-0001 /A'), 1   , false   , (SELECT st_id FROM stv where st_zn = 'E.B.PKW.A-1168534 /A' AND st_n = 'E.B.PKW.A-1168534-0001 /A')),
      --Sensorik
      ('G.PKW.MON-BC.A-1168534 /A', 'E.B.PKW.A-1168534-0100 /A' , 20    , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('E.B.PKW.A-1168534-0100 /A'), 1   , false   , (SELECT st_id FROM stv where st_zn = 'E.B.PKW.A-1168534 /A' AND st_n = 'E.B.PKW.A-1168534-0100 /A')),
       --Kühlung Sensoreinheit direkt in Stückliste
      (art_getriebe, 'E.B.PKW.A-1168534-0101 /A' , 90    , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('E.B.PKW.A-1168534-0101 /A'), 1   , false   , (SELECT st_id FROM stv where st_zn = 'E.B.PKW.A-1168534 /A' AND st_n = 'E.B.PKW.A-1168534-0101 /A'))
      ;
 --Arbeitspaket unter Getriebe
    INSERT INTO stv
      (st_zn,           st_n            , st_pos,    st_m, st_mgc)
     VALUES
      (art_getriebe,  'G.PKW.MON-BC.A-1168534 /A' ,    100 ,   1   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('G.PKW.MON-BC.A-1168534 /A'));
 --
 --Reperatur / Überholung Getriebe
  --Austausch Welle, Lager
    INSERT INTO stv
      (st_zn, st_n, st_pos, st_m, st_mgc)          VALUES  (art_getriebe_rep,  art_getriebe_rep_welle,    10 ,   1   , art_welle_mgcid);
    INSERT INTO stv
      (st_zn, st_n, st_pos, st_m, st_mgc)          VALUES  (art_getriebe_rep,  art_getriebe_rep_lager,    20 ,   1   , art_welle_mgcid);
    INSERT INTO stv
      (st_zn, st_n, st_pos, st_m, st_mgc)          VALUES  (art_getriebe_rep,  art_getriebe_rep_option,    30 ,   1   , art_welle_mgcid);

-------------------------------------------------------------------------------------
--Sicherstellen das alle Artikel mit Mengeneinheit anglegt sind. artmgc prüfen
 INSERT INTO artmgc (m_ak_nr, m_mgcode, m_uf)
  SELECT ak_nr, ak_standard_mgc,1 FROM art WHERE NOT EXISTS (
    SELECT true FROM artmgc WHERE m_ak_nr = ak_nr AND m_mgcode = ak_standard_mgc
  );

-------------------------------------------------------------------------------------
--AVOR anlegen
  --Welle   'W.13.N-272.371 /C'      op_ix = 100
    INSERT INTO opl
      (op_n               , op_ix, op_vi, op_lg)
     VALUES
      (art_welle, 100  ,     1,     6);

    INSERT INTO op2 --Sägen
      (o2_ix, o2_n, o2_txt                 , o2_ks, o2_tr, o2_th, o2_tn)
     VALUES
      (100,   10,   'Sägen auf 37 mm 6 Stk', 'SAG-005',  0.5,     5, 2);

    INSERT INTO op2 --Drehen Nut
      (o2_ix, o2_n, o2_txt           , o2_ks, o2_tr, o2_th, o2_tn)
     VALUES
      (100,   20,   'Nut eindrehen'  , 'DRE-001',  0.75,     7, 1);

    INSERT INTO op2 --Glühen/Härten
      (o2_ix, o2_n, o2_txt           , o2_ks, o2_aw, o2_dlz, o2_aknr, o2_tr, o2_awpreis, o2_awpreisfix)
     VALUES
      (100,   30,   'Härten'  , 'GLU-001',  true, 5, 'GLU-500', 5, 7.5, 15);

    INSERT INTO op6
      (o6_aknr          , o6_ix, o6_m, o6_m_stat, o6_mce                            , o6_artpr)
     VALUES
      ('1.2210 Ø14X1000',   100,    1,         1, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('1.2210 Ø14X1000'), 25      );

    -- Alternativ-Material
    INSERT INTO op6
      (o6_aknr               , o6_ix, o6_m, o6_m_stat, o6_mce                            , o6_artpr, o6_stat)
     VALUES
      ('1.2210 Ø14X1000-1000',   100,    1,         1, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('1.2210 Ø14X1000-1000'), 25      , 'AM');

    INSERT INTO op6
      (o6_aknr               , o6_ix, o6_m, o6_m_stat, o6_mce                            , o6_artpr, o6_stat)
     VALUES
      ('1.2210 Ø14X1000-1002',   100,    1,         1, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('1.2210 Ø14X1000-1002'), 25      , 'AM');

  --Getriebe
    INSERT INTO opl
      (op_n                , op_ix, op_vi, op_lg)
     VALUES
      (art_getriebe, 200  ,     1,    1);

    INSERT INTO op2
      (o2_ix, o2_n, o2_txt   , o2_ks, o2_tr, o2_th)
     VALUES
      (200,   10,   'Montage', 'MON-001',  0.5,     60);

  --L-Profil mit Zuschnitt
    INSERT INTO opl
      (op_n      , op_ix, op_vi, op_lg)
     VALUES
      (art_lprofil, 300  ,     1,   20);

    INSERT INTO op2 --Sägen
      (o2_ix, o2_n, o2_txt                 , o2_ks,    o2_tr,   o2_th, o2_tn)
     VALUES
      (300,   10,   'Sägen gem. Zeichnung', 'SAG-005',  0.5,     3, 1);

    INSERT INTO op6
      (o6_aknr          , o6_ix, o6_m, o6_stkz, o6_lz, o6_zz, o6_zme, o6_m_stat, o6_mce                    , o6_artpr, o6_zaknr, o6_txt, o6_folgebearb1)
     VALUES
      ('1.2210 Ø14X1000', 300,    1,    2     ,  100,  2, get_mgcode_mm(),     1, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('1.2210 Ø14X1000'), 7, 'Z-01', 'Auf Schnittkante achten', 'Entgraten'),
      ('1.2210 Ø14X1000', 300,    1,    1     , 1000,  2, get_mgcode_mm(),     1, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('1.2210 Ø14X1000'), 7, 'Z-02', 'Anschnitt langsam', 'Entgraten')
      ;
  --Lochplatte   'Lochplatte 120x20x1'      op_ix = 400
    INSERT INTO opl
      (op_n                 , op_ix, op_vi, op_lg)
     VALUES
      (art_lochplatte, 400  ,     1,     1);

    INSERT INTO op2 --Bohren
      (o2_ix, o2_n, o2_txt                           , o2_ks    , o2_tr, o2_th, o2_tn)
     VALUES
      (400,   10,   'Löcher gem. Zeichnung bohren 3x', 'SBM-001', 0.5  , 1    , 1);

-- zwei Lieferantenpreis für Lochplatte anlegen, einer fertig und einer mit Folge-ABK
    INSERT INTO epreis --Lieferant ELEK für
      (e_aknr        , e_best            , e_lkn   , e_ep , e_mcv                          , e_lfzt , e_stal, e_folgeap_op_ix)
     VALUES
-- Lieferant STAHL für Komplettlieferung
      (art_lochplatte, 'LP120020001'     , 'STAHL' , 15.00, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_lochplatte), 15     , false , NULL),
-- Lieferant HALBS für Lieferung (unfertig) mit Folge-ABK
      (art_lochplatte, 'PL-120-20-01'    , 'HALBS' ,  3.00, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_lochplatte), 5      , true  , 400);

---------------------------------------------------------------------------------------
 PERFORM SetVal('opl_op_ix_seq', '1000');
---------------------------------------------------------------------------------------
--Lagerorte (Stammdaten/Vorgaben) anlegen
    INSERT INTO lagerorte
     (lgo_desc            , lgo_name , lgo_nodelete)
    VALUES
     ('Fertigungslager'   , 'FERT', true),
     ('Zwischenlager'     , 'ZL'  , true),
     ('Wareneingangslager', 'WE'  , true),
     ('Warenausgangslager', 'WA'  , true),
     ('Regal 1'           , 'R1'  , true),
     ('Regal 2'           , 'R2'  , true);

---------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------
--Lagerbereich (Stammdaten/Vorgaben) anlegen
INSERT INTO lagerbereich
     (lgb_descr     ,lgb_name )
    VALUES
     ('Halle 1'     , 'H1'),
     ('Halle 2'     , 'H2');
---------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------
--Lagerzuordnung anlegen
INSERT INTO lagerortzuo
  (lgz_lgo_name, lgz_lgb_name, insert_by, insert_date, modified_by, modified_date)
VALUES
  ('R1', 'H1', current_user, current_date, current_user, current_date),
  ('R2', 'H1', current_user, current_date, current_user, current_date),
  ('R1', 'H2', current_user, current_date, current_user, current_date),
  ('R2', 'H2', current_user, current_date, current_user, current_date);
---------------------------------------------------------------------------------------


--Sonstiges
 --Projekt
  INSERT INTO anl (an_nr, an_bez) VALUES (banf_pjnr, 'Entwicklung Welle W.13.N-272.371 /C : neue Werkstoffe');

--------------------------------------------------------------------------------------
 --- Projektstruktur: Reperatur Getriebe Welle
 INSERT INTO anlstruktur (anst_id , anst_bem)
  VALUES                 (anst_id, 'Reperatur Getriebe Welle');

 INSERT INTO anlstrprofil (ansp_anst_id, ansp_ident, ansp_pos, ansp_ap_nr)
  VALUES                  (anst_id     ,          1,        1, art_getriebe_rep_welle);
 --- AVOR
 IF NOT EXISTS(SELECT true FROM opl WHERE op_n = art_getriebe_rep_welle) THEN
    INSERT INTO opl (op_n                  , op_ix, op_vi, op_lg)
       VALUES       (art_getriebe_rep_welle, 700  ,     1,     1);

    INSERT INTO op2 (o2_ix, o2_n, o2_txt         , o2_ks    , o2_tr, o2_th, o2_tv)
       VALUES       (700,   10,   'Montage Welle', 'MON-001',     1,   240,    10);
 END IF;

END $$;



--- Techplan: Demo-Daten sowie Screencast
DO $$
  DECLARE
    myart_nr      VARCHAR := 'W.13.N-272.371 /TPL';
    my_wz_art_nr      VARCHAR := 'W-0001-SF.12MM';
    myop_ix       INTEGER := (SELECT op_ix FROM opl ORDER BY op_ix DESC LIMIT 1) + 10;
    myo2_txt      TEXT;
    myid          INTEGER;
    myo5_txt      TEXT;
BEGIN
    --- Artikel anlegen
    INSERT INTO art (ak_ac   , ak_fertigung, ak_nr   , ak_bez     , ak_mat   , ak_dim     , ak_din  , ak_znr   , ak_idx, ak_standard_mgc, ak_bfr, ak_vkprund, ak_pknr, ak_nrhl  , insert_by   , insert_date )
    VALUES          ('PR1001', true        , myart_nr, 'Welle Nut', '115CrV3', 'Ø13x37 mm', '1.2210', '272.371', NULL  , 1              , 25    , 0.01      , 1      , myart_nr , current_user, current_date);

    --- Werkzeug-Artikel anlegen
    INSERT INTO artcod (ac_n    , ac_i, ac_b       )
    SELECT              'WKZ.FR', 1   , 'Werkzeuge'
    WHERE NOT EXISTS(SELECT TRUE FROM artcod WHERE ac_n = 'WKZ.FR');

    INSERT INTO art (ak_ac   , ak_fertigung, ak_nr        , ak_bez              , ak_mat, ak_dim , ak_standard_mgc, insert_by   , insert_date )
    VALUES          ('WKZ.FR', false        , my_wz_art_nr, 'Schaftfräser 12 mm', NULL  , '12 mm', 1              , current_user, current_date);

    --- AVOR-Stammkarte anlegen
    INSERT INTO opl (op_n    , op_ix  , op_vi, op_lg, insert_by   , insert_date )
    VALUES          (myart_nr, myop_ix, '1'  , 6    , current_user, current_date);

    --- Arbeitsgänge anlegen

    ----- AG 10
    myo2_txt := 'Sägen';
    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr  , o2_tr_sek, o2_th , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 10  , myo2_txt, 2          , 2          , 'SAG-002', true , 15.0000, 900.0000 , 0.2500, 15.0000  , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;

    --- AG 10 - Arbeitsschritte
    myo5_txt     := 'Sägen';
    INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
    VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, 15   , 0.02, current_user, current_date);
    ---
    -----

    ----- AG 20
    myo2_txt := 'Schruppen (Plan)
    Schruppen (Kontur grob)
    Schruppen (Kontur fein)
    Schruppen (offene Nut 1 von 4)
    Schruppen (offene Nut 2 von 4)
    Schruppen (offene Nut 3 von 4)
    Schruppen (offene Nut 4 von 4)';

    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr  , o2_tr_sek, o2_th , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 20  , myo2_txt, 2          , 2          , 'FRA-001', true , 30.0000, 1800.0000, 7.1040, 426.2400 , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;

     --- AG 20 - Arbeitsschritte
      myo5_txt     := 'Schruppen (Plan)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, 30   , 2.18, current_user, current_date);

      myo5_txt     := 'Schruppen (Kontur grob)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 20     , myo5_txt, my_wz_art_nr, NULL , 2.18, current_user, current_date);

      myo5_txt     := 'Schruppen (Kontur fein)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 30     , myo5_txt, my_wz_art_nr, NULL , 2.18, current_user, current_date);

      myo5_txt     := 'Schruppen (offene Nut 1 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 40     , myo5_txt, my_wz_art_nr, NULL , 0.14, current_user, current_date);

      myo5_txt     := 'Schruppen (offene Nut 2 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 50     , myo5_txt, my_wz_art_nr, NULL , 0.14, current_user, current_date);

      myo5_txt     := 'Schruppen (offene Nut 3 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 60     , myo5_txt, my_wz_art_nr, NULL , 0.14, current_user, current_date);

      myo5_txt     := 'Schruppen (offene Nut 4 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 70     , myo5_txt, my_wz_art_nr, NULL , 0.14, current_user, current_date);
     ---
    -----

    ----- AG 30
    myo2_txt := 'Schlichten Außenkontur rechts
    Schlichten Außenkontur links
    Schlichten Außenkontur vorn (Zapfen)
    Schlichten Außenkontur hinten
    Nut fräsen vor Zapfen
    ';
    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr , o2_tr_sek, o2_th  , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 30  , myo2_txt, 2          , 2          , 'FRA-001', true , 0.0000, 0.0000   , 11.9577, 717.4620 , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;


     --- AG 30 - Arbeitsschritte
      myo5_txt     := 'Schlichten Außenkontur rechts';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, NULL , 2.72, current_user, current_date);

      myo5_txt     := 'Schlichten Außenkontur links';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 20     , myo5_txt, my_wz_art_nr, NULL , 2.72, current_user, current_date);

      myo5_txt     := 'Schlichten Außenkontur vorn (Zapfen)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 30     , myo5_txt, my_wz_art_nr, NULL , 2.72, current_user, current_date);

      myo5_txt     := 'Schlichten Außenkontur hinten';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 40     , myo5_txt, my_wz_art_nr, NULL , 2.72, current_user, current_date);

      myo5_txt     := 'Nut fräsen vor Zapfen';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 50     , myo5_txt, my_wz_art_nr, NULL , 1.07, current_user, current_date);
     ---
    -----

    ----- AG 40
    myo2_txt := 'Nut fräsen hinter Zapfen';
    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr , o2_tr_sek, o2_th , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 40  , myo2_txt, 2          , 2          , 'FRA-001', true , 0.0000, 0.0000   , 1.5850, 95.1000  , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;

     --- AG 40 - Arbeitsschritte
      myo5_txt     := 'Nut fräsen hinter Zapfen';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, NULL , 1.59, current_user, current_date);
     ---
    -----

    ----- AG 50
    myo2_txt := 'Radien schlichten (Radius 1 mm fräsen)';
    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr , o2_tr_sek, o2_th , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 50  , myo2_txt, 2          , 2          , 'FRA-001', true , 0.0000, 0.0000   , 0.1289, 7.7340   , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;

     --- AG 50 - Arbeitsschritte
      myo5_txt     := 'Radien schlichten (Radius 1 mm fräsen)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, NULL , 1.59, current_user, current_date);
     ---
    -----

    ----- AG 60
    myo2_txt := 'Radius 1mm fräsen (offene Nut 1 von 4)
    Radius 1mm fräsen (offene Nut 2 von 4)
    Radius 1mm fräsen (offene Nut 3 von 4)
    Radius 1mm fräsen (offene Nut 4 von 4)
    ';
    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr , o2_tr_sek, o2_th , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 60  , myo2_txt, 2          , 2          , 'FRA-001', true , 0.0000, 0.0000   , 0.2219, 13.3140  , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;

     --- AG 60 - Arbeitsschritte
      myo5_txt     := 'Radius 1mm fräsen (offene Nut 1 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, NULL , 0.06, current_user, current_date);

      myo5_txt     := 'Radius 1mm fräsen (offene Nut 2 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 20     , myo5_txt, my_wz_art_nr, NULL , 0.06, current_user, current_date);

      myo5_txt     := 'Radius 1mm fräsen (offene Nut 3 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 30     , myo5_txt, my_wz_art_nr, NULL , 0.06, current_user, current_date);

      myo5_txt     := 'Radius 1mm fräsen (offene Nut 4 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 40     , myo5_txt, my_wz_art_nr, NULL , 0.06, current_user, current_date);
     ---
    -----

    ----- AG 70
    myo2_txt := 'Radien 2mm fräsen hinter Zapfen
    Radien 2mm fräsen vorn
    ';
    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr , o2_tr_sek, o2_th , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 70  , myo2_txt, 2          , 2          , 'FRA-001', true , 0.0000, 0.0000   , 0.2903, 17.4180  , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;

     --- AG 70 - Arbeitsschritte
      myo5_txt     := 'Radien 2mm fräsen hinter Zapfen';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, NULL , 0.15, current_user, current_date);

      myo5_txt     := 'Radien 2mm fräsen vorn';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 20     , myo5_txt, my_wz_art_nr, NULL , 0.15, current_user, current_date);
     ---
    -----

    ----- AG 80
    myo2_txt := 'Gewindebohren
    Gewindefräsen
    ';
    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr , o2_tr_sek, o2_th , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 80  , myo2_txt, 2          , 2          , 'FRA-001', true , 0.0000, 0.0000   , 0.5631, 33.7860  , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;

     --- AG 80 - Arbeitsschritte
      myo5_txt     := 'Gewindebohren';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, NULL , 0.06, current_user, current_date);

      myo5_txt     := 'Gewindefräsen';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 20     , myo5_txt, my_wz_art_nr, NULL , 0.06, current_user, current_date);
     ---
    -----

    ----- AG 90
    myo2_txt := 'Aufspannungswechsel
    Schruppen (plan)
    Schlichten Innenkontur
    ';
    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr  , o2_tr_sek, o2_th , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 90  , myo2_txt, 2          , 2          , 'FRA-001', true , 30.0000, 0.0000   , 2.8023, 168.1380 , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;

     --- AG 90 - Arbeitsschritte
      myo5_txt     := 'Aufspannungswechsel';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, NULL , 0.0, current_user, current_date);

      myo5_txt     := 'Schruppen (plan)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 20     , myo5_txt, my_wz_art_nr, NULL , 1.63, current_user, current_date);

      myo5_txt     := 'Schlichten Innenkontur';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 30     , myo5_txt, my_wz_art_nr, NULL , 1.170, current_user, current_date);
     ---
    -----

    ----- AG 100
    myo2_txt := 'Radien schlichten (Radius 1mm offene Nut 1 von 4)
    Radien schlichten (Radius 1mm offene Nut 2 von 4)
    Radien schlichten (Radius 1mm offene Nut 3 von 4)
    Radien schlichten (Radius 1mm offene Nut 4 von 4)
    ';
    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr , o2_tr_sek, o2_th , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 100 , myo2_txt, 2          , 2          , 'FRA-001', true , 0.0000, 0.0000   , 0.2968, 17.8080  , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;

     --- AG 100 - Arbeitsschritte
      myo5_txt     := 'Radien schlichten (Radius 1mm offene Nut 1 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, NULL , 0.07, current_user, current_date);

      myo5_txt     := 'Radien schlichten (Radius 1mm offene Nut 2 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 20     , myo5_txt, my_wz_art_nr, NULL , 0.07, current_user, current_date);

      myo5_txt     := 'Radien schlichten (Radius 1mm offene Nut 3 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 30     , myo5_txt, my_wz_art_nr, NULL , 0.07, current_user, current_date);

      myo5_txt     := 'Radien schlichten (Radius 1mm offene Nut 4 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 40     , myo5_txt, my_wz_art_nr, NULL , 0.07, current_user, current_date);
     ---
    -----

    ----- AG 110
    myo2_txt := 'Fase fräsen Außenseite';
    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr , o2_tr_sek, o2_th , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 110 , myo2_txt, 2          , 2          , 'FRA-001', true , 0.0000, 0.0000   , 1.0820, 64.9200  , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;

     --- AG 110 - Arbeitsschritte
      myo5_txt     := 'Fase fräsen Außenseite';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, NULL , 1.08, current_user, current_date);
     ---
    -----

    ----- AG 120
    myo2_txt := 'Aufspannungswechsel
    Zapfen fräsen
    ';
    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr , o2_tr_sek, o2_th , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 120 , myo2_txt, 2          , 2          , 'FRA-001', true , 0.0000, 0.0000   , 0.0818, 4.9080   , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;

     --- AG 120 - Arbeitsschritte
      myo5_txt     := 'Aufspannungswechsel';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, NULL , 0.00, current_user, current_date);

      myo5_txt     := 'Zapfen fräsen';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 20     , myo5_txt, my_wz_art_nr, NULL , 0.03, current_user, current_date);
     ---
    -----
 END $$ LANGUAGE plpgsql;
---
--- #17967 x2e Alternativartikel
DO $$
DECLARE _art_dbrid varchar(32);
BEGIN

    INSERT INTO recnocommentkategorie( rck_id, rck_b          , rck_gruppe  , rck_column )
    SELECT                             'art' , 'Artikelnummer', 'Stammdaten', 'ak_nr'
    WHERE NOT EXISTS( SELECT TRUE FROM recnocommentkategorie WHERE rck_id = 'art' );
    ---
    INSERT INTO art( ak_ac   ,  ak_nr              , ak_bez                                                  , ak_standard_mgc, ak_bfr, ak_rust, ak_vkpbas, ak_vkprund, ak_pknr )
    VALUES         ( 'EM1001', 'MF0207FTE52-100K-1', 'Metallschicht-Widerstand 100 kâ„¦ axial bedrahtet 0207',               1,      1,     250,     38.68,       0.01,       1 )
    RETURNING dbrid INTO _art_dbrid;

    INSERT INTO recnokeyword( r_tablename, r_kategorie, r_descr                , r_unit , r_value         , r_reg_pname            , r_dbrid    )
    VALUES                  ( 'art'      , null       ,''                      ,''      ,'5'              ,'skill.intervall'       , _art_dbrid ),
                            ( 'art'      , null       ,''                      ,''      ,'111 K1'         ,'CoC.ART.Sonstiges'     , _art_dbrid ),
                            ( 'art'      , 'art'      ,'Bauart'                ,''      ,'axial bedrahtet',''                      , _art_dbrid ),
                            ( 'art'      , 'art'      ,'Belastbarkeit'         ,'W'     ,'0.6'            ,''                      , _art_dbrid ),
                            ( 'art'      , 'art'      ,'Test-GEO'              ,''      ,'test'           ,''                      , _art_dbrid );
    ---
    INSERT INTO art( ak_ac   ,  ak_nr              , ak_bez                                                  , ak_standard_mgc, ak_bfr, ak_rust, ak_vkpbas, ak_vkprund, ak_pknr )
    VALUES         ( 'EM1001', 'MF0207FTE52-100K-2', 'Metallschicht-Widerstand 100 kâ„¦ axial bedrahtet 0207',               1,      1,     250,     38.68,       0.01,       1 )
    RETURNING dbrid INTO _art_dbrid;

    INSERT INTO recnokeyword( r_tablename, r_kategorie, r_descr                , r_unit , r_value         , r_reg_pname            , r_dbrid    )
    VALUES                  ( 'art'      , null       ,''                      ,''      ,'5'              ,'skill.intervall'       , _art_dbrid ),
                            ( 'art'      , null       ,''                      ,''      ,'111 K2'         ,'CoC.ART.Sonstiges'     , _art_dbrid ),
                            ( 'art'      , 'art'      ,'Bauart'                ,''      ,'axial bedrahtet',''                      , _art_dbrid ),
                            ( 'art'      , 'art'      ,'Belastbarkeit'         ,'W'     ,'0.6'            ,''                      , _art_dbrid ),
                            ( 'art'      , 'art'      ,'Test-GEO'              ,''      ,'test'           ,''                      , _art_dbrid );
    ---
    INSERT INTO art( ak_ac   ,  ak_nr              , ak_bez                                                  , ak_standard_mgc, ak_bfr, ak_rust, ak_vkpbas, ak_vkprund, ak_pknr )
    VALUES         ( 'EM1001', 'MF0207FTE52-1M'    , 'Metallschicht-Widerstand 100 kâ„¦ axial bedrahtet 0207',               1,      1,     250,     38.68,       0.01,       1 )
    RETURNING dbrid INTO _art_dbrid;

    INSERT INTO recnokeyword( r_tablename, r_kategorie, r_descr                , r_unit , r_value         , r_reg_pname            , r_dbrid    )
    VALUES                  ( 'art'      , null       ,'Bemerkungstext'        ,''      ,'a'              ,'CoC.ART.Bemerkungstext', _art_dbrid ),
                            ( 'art'      , null       ,'Bauart'                ,''      ,'axial bedrahtet',''                      , _art_dbrid ),
                            ( 'art'      , null       ,'Temperatur-Koeffizient','ppm/°C','±50'            ,''                      , _art_dbrid ),
                            ( 'art'      , null       ,'A'                     ,''      ,'B'              ,''                      , _art_dbrid );
    ---
    INSERT INTO art( ak_ac   ,  ak_nr              , ak_bez                                                  , ak_standard_mgc, ak_bfr, ak_rust, ak_vkpbas, ak_vkprund, ak_pknr )
    VALUES         ( 'EM1001', 'MF0207FTE52-100K'  , 'Metallschicht-Widerstand 100 kâ„¦ axial bedrahtet 0207',               1,      1,     250,     38.68,       0.01,       1 )
    RETURNING dbrid INTO _art_dbrid;

    INSERT INTO recnokeyword( r_tablename, r_kategorie, r_descr                , r_unit , r_value         , r_reg_pname            , r_dbrid    )
    VALUES                  ( 'art'      , null       ,'Prüfintervall'         ,''      ,'5'              ,'skill.intervall'       , _art_dbrid ),
                            ( 'art'      , null       ,'Sonstiges / Other'     ,''      ,'111'            ,'CoC.ART.Sonstiges'     , _art_dbrid ),
                            ( 'art'      , 'art'      ,'Bauart'                ,''      ,'axial bedrahtet',''                      , _art_dbrid ),
                            ( 'art'      , 'art'      ,'Belastbarkeit'         ,'W'     ,'0.6'            ,''                      , _art_dbrid ),
                            ( 'art'      , 'art'      ,'Test-GEO'              ,''      ,'test'           ,''                      , _art_dbrid );
    ---
    INSERT INTO art( ak_ac   ,  ak_nr              , ak_bez                                                  , ak_standard_mgc, ak_bfr, ak_rust, ak_vkpbas, ak_vkprund, ak_pknr )
    VALUES         ( 'EM1001', 'MF0207FTE52-1000K' , 'Metallschicht-Widerstand 100 kâ„¦ axial bedrahtet 0207',               1,      1,     250,     38.68,       0.01,       1 );

    INSERT INTO artoption_arts( aoa_pos, aoa_g_ak_nr       , aoa_ak_nr )

    VALUES                    ( 1      , 'MF0207FTE52-100K', 'MF0207FTE52-1M'),
                              ( 1      , 'MF0207FTE52-1M'  , 'MF0207FTE52-100K-1'),
                              ( 2      , 'MF0207FTE52-1M'  , 'MF0207FTE52-100K-2');

END $$ LANGUAGE plpgsql;
---
--- #18299 x2e Stückliste Demo-Daten
DO $$
 DECLARE
    _ak_ac                 VARCHAR := 'RM1001';
    _artnr_1884            VARCHAR := 'X_00001884';
    _artbez_1884           VARCHAR := 'CC_0402_100N_6V30_10P0_X7R';
    _artnr_2684            VARCHAR := 'X_00002684';
    _artbez_2684           VARCHAR := 'CC_0402_100N_50V0_10P0_X7R';
    _artnr_3151            VARCHAR := 'X_00003151';
    _artbez_3151           VARCHAR := 'IF_X2E_RS232_08CH_2.03_00000000_00';
    _artnr_5557            VARCHAR := 'X_00005557';
    _artbez_5557           VARCHAR := 'CCC_0402_100N_50V0_10P0_X7R_TDK_CGA';
    _artnr_6037            VARCHAR := 'X_00006037';
    _artbez_6037           VARCHAR := 'CC_0402_100N_50V0_10P0_X7R_Walsin_MLCC';

 BEGIN

    INSERT INTO art ( ak_ac , ak_nr      , ak_bez      , ak_standard_mgc, ak_lag)
    VALUES          ( _ak_ac, _artnr_1884, _artbez_1884, 1              , true),
                    ( _ak_ac, _artnr_2684, _artbez_2684, 1              , true),
                    ( _ak_ac, _artnr_3151, _artbez_3151, 1              , true),
                    ( _ak_ac, _artnr_5557, _artbez_5557, 1              , true),
                    ( _ak_ac, _artnr_6037, _artbez_6037, 1              , true);

    INSERT INTO stv ( st_zn       , st_n        , st_pos, st_m, st_mgc )
    VALUES          ( _artnr_3151 , _artnr_1884 , 10    , 1   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc( _artnr_1884 ) ),
                    ( _artnr_1884 , _artnr_2684 , 10    , 1   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc( _artnr_2684 ) ),
                    ( _artnr_2684 , _artnr_5557 , 10    , 1   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc( _artnr_5557 ) );


    INSERT INTO artoption_arts ( aoa_pos, aoa_g_ak_nr , aoa_ak_nr   )
    VALUES                     ( 1      , _artnr_2684 , _artnr_5557 ),
                               ( 1      , _artnr_6037 , _artnr_2684 ),
                               ( 1      , _artnr_2684 , _artnr_6037 ),
                               ( 1      , _artnr_5557 , _artnr_6037 ),
                               ( 2      , _artnr_6037 , _artnr_5557 );

 END $$ LANGUAGE plpgsql;
---

--- #17221 [Marketing] Gefahrstoff Demodaten in Quellen übernehme
--- Demodaten für Gefahrgut
DO $$       --- Artikel anlegen
  DECLARE
      --Artikel
      art_aceton    VARCHAR;
      art_lack_rot  VARCHAR;
  BEGIN
    -- Stammdaten
    INSERT INTO art ( ak_ac, ak_nr, ak_bez, ak_standard_mgc, ak_gefahrgut )
     SELECT
       'KT1001',
       TSystem.getnumcirclenr('art', True),
       'Aceton',
       1,
       true
     WHERE NOT EXISTS (SELECT TRUE FROM art WHERE ak_bez = 'Aceton')
     RETURNING dbrid INTO art_aceton;

     IF art_aceton IS NULL THEN
       SELECT dbrid INTO art_aceton FROM art WHERE ak_bez = 'Aceton';
     END IF;

    -- Parameter für Aceton setzen
    PERFORM trecnoparam.set('ak_gefahrgut.anz_personen', art_aceton, 5);
    PERFORM trecnoparam.set('ak_gefahrgut.bereich', art_aceton, 'Werkstatt');
    PERFORM trecnoparam.set('ak_gefahrgut.hinweis', art_aceton, 'H225,H319,H336');
    PERFORM trecnoparam.set('ak_gefahrgut.merkmal', art_aceton, 'EH066');
    PERFORM trecnoparam.set('ak_gefahrgut.piktogramm', art_aceton, 'GHS02,GHS07');
    PERFORM trecnoparam.set('ak_gefahrgut.sicherheit', art_aceton, 'P210,P305+P351+P338,P403+P233');
    PERFORM trecnoparam.set('ak_gefahrgut.signalwort', art_aceton, 'DGR');

    -- Artikel Lack erstellen
    INSERT INTO art ( ak_ac, ak_nr, ak_bez, ak_standard_mgc, ak_gefahrgut )
     SELECT
       'KT1001',
       TSystem.getnumcirclenr('art', True),
       'PU Lack RAL 3000 Feuerrot',
       1,
       true
     WHERE NOT EXISTS (SELECT TRUE FROM art WHERE ak_bez = 'PU Lack RAL 3000 Feuerrot')
     RETURNING dbrid INTO art_lack_rot;

     IF art_lack_rot IS NULL THEN
       SELECT dbrid INTO art_lack_rot FROM art WHERE ak_bez = 'PU Lack RAL 3000 Feuerrot';
     END IF;

    -- Parameter für PU Lack RAL 3000 Feuerrot setzen
    PERFORM trecnoparam.set('ak_gefahrgut.anz_personen', art_lack_rot, 6);
    PERFORM trecnoparam.set('ak_gefahrgut.bereich', art_lack_rot, 'Werkstatt');
    PERFORM trecnoparam.set('ak_gefahrgut.hinweis', art_lack_rot, 'H317');
    PERFORM trecnoparam.set('ak_gefahrgut.piktogramm', art_lack_rot, 'GHS07');
    PERFORM trecnoparam.set('ak_gefahrgut.sicherheit', art_lack_rot, 'P102');
    PERFORM trecnoparam.set('ak_gefahrgut.signalwort', art_lack_rot, 'WNG');

  END $$;

-- END DEMO-SESSION
RESET SESSION AUTHORIZATION;
